SET QUOTED_IDENTIFIER ON

GO

BEGIN
    PRINT '';
    PRINT '=== Granting admin permissions for all SPs ===';

    DECLARE @ProcName NVARCHAR(500);
    DECLARE @Counter INT = 0;

    DECLARE proc_cursor CURSOR LOCAL FAST_FORWARD FOR
        SELECT QUOTENAME(s.name) + '.' + QUOTENAME(p.name)
        FROM sys.procedures p
        INNER JOIN sys.schemas s ON p.schema_id = s.schema_id
        WHERE s.name IN ('DEL', 'FAB', 'LB', 'MES', 'SEC', 'SYSTEM', 'UTL')
        ORDER BY s.name, p.name;

    OPEN proc_cursor;
    FETCH NEXT FROM proc_cursor INTO @ProcName;

    WHILE @@FETCH_STATUS = 0
    BEGIN
        BEGIN TRY
            EXEC [SEC].[UpsertProcedureAndSetToProfile] @ProcName, 'admin Profile', 'PostDeployment';
            SET @Counter = @Counter + 1;
        END TRY
        BEGIN CATCH
            PRINT 'Warning: Could not grant permission for ' + @ProcName + ': ' + ERROR_MESSAGE();
        END CATCH

        FETCH NEXT FROM proc_cursor INTO @ProcName;
    END

    CLOSE proc_cursor;
    DEALLOCATE proc_cursor;

END
