SET QUOTED_IDENTIFIER ON
GO

-- IsHeatIdManual Default
-- Check if the default constraint exists
IF NOT EXISTS (
    SELECT 1
    FROM sys.default_constraints dc
    INNER JOIN sys.columns c ON dc.parent_object_id = c.object_id AND dc.parent_column_id = c.column_id
    WHERE c.name = 'IsHeatIdManual'
      AND OBJECT_NAME(dc.parent_object_id) = 'Processes'
)
BEGIN
    -- Remove any inline default constraint (if necessary)
    ALTER TABLE [MS].[Processes]
    ALTER COLUMN [IsHeatIdManual] BIT NOT NULL;

    -- Add the named default constraint
    ALTER TABLE [MS].[Processes]
    ADD CONSTRAINT [DF_Processes_IsHeatIdManual]
    DEFAULT ((0)) FOR [IsHeatIdManual];
END
      
