

SET QUOTED_IDENTIFIER ON
GO

-- IsHeatIdManual Default
-- Check if the default constraint exists
IF NOT EXISTS (
    SELECT 1
    FROM sys.default_constraints dc
    INNER JOIN sys.columns c ON dc.parent_object_id = c.object_id AND dc.parent_column_id = c.column_id
    WHERE c.name = 'IsHeatIdManual'
      AND OBJECT_NAME(dc.parent_object_id) = 'Processes'
)
BEGIN
    -- Remove any inline default constraint (if necessary)
    ALTER TABLE [MS].[Processes]
    ALTER COLUMN [IsHeatIdManual] BIT NOT NULL;

    -- Add the named default constraint
    ALTER TABLE [MS].[Processes]
    ADD CONSTRAINT [DF_Processes_IsHeatIdManual]
    DEFAULT ((0)) FOR [IsHeatIdManual];
END
      
  EXEC [SEC].[UpsertProcedureAndSetToProfile] 'CAS.SearchHeatsWithLadleClose', 'admin Profile', 'dexteel'
    EXEC [SEC].[UpsertProcedureAndSetToProfile] 'CAS.GetProductionData', 'admin Profile', 'dexteel'
  
  -- Register EAFProcessTimesChanged event
  EXEC SYSTEM.RegisterEvent
      @EventName = 'EAFProcessTimesChanged',
      @Description = 'Fired when EAF process Start or End times are modified. Triggers re-import of process data from PLC.'

  -- Subscribe SWV handler to the event
  EXEC SYSTEM.SubscribeToEvent
      @EventName = 'EAFProcessTimesChanged',
      @ProcedureToExecute = 'SWV.HandleEAFProcessTimesChanged',
      @IsLoggedEvent = 1
      

       -- Feature flag to enable/disable the delivery ticket alert
  INSERT INTO UTL.catSettings (SettingName, Value, Description)
  VALUES (
      'FF_CASTER_DE_DELIVERY_TICKET_ALERT',
      0,
      'Feature flag to enable delivery ticket alert banner in Caster Data Entry. Set to 1 to
  enable, 0 to disable.'
  );

  -- Time offset for delivery ticket alerts
  INSERT INTO UTL.catSettings (SettingName, Value, Description)
  VALUES (
      'CASTER_DE_DELIVERY_TICKET_ALERT_OFFSET_TIME_IN_MINUTES',
      120,
      'Number of minutes after LadleClose before showing delivery ticket alert. Default is 120
  minutes (2 hours).'
  );
  
